/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.SwapValues;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="ClassValuePicker", category="Evaluation", toolTipText="Designate which class value is considered the \"positive\" class value (useful for ROC analysis)", iconPath="weka/gui/knowledgeflow/icons/ClassValuePicker.gif")
public class ClassValuePicker
extends BaseStep {
    private static final long serialVersionUID = 8558445535347028472L;
    protected String m_classValueS = "/first";
    protected String m_classValue = "/first";
    protected boolean m_classIsSet;
    protected boolean m_classIsNominal;

    @OptionMetadata(displayName="Class value", description="The class value to consider as the 'positive' class", displayOrder=1)
    public void setClassValue(String value) {
        this.m_classValueS = value;
    }

    public String getClassValue() {
        return this.m_classValueS;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_classIsSet = true;
        this.m_classIsNominal = true;
        this.m_classValue = this.getStepManager().environmentSubstitute(this.m_classValueS).trim();
        if (this.m_classValue.length() == 0) {
            throw new WekaException("No class label specified as the positive class!");
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        Instances dataSet = (Instances)data.getPayloadElement(data.getConnectionName());
        if (dataSet == null) {
            throw new WekaException("Data should not be null!");
        }
        if (dataSet.classAttribute() == null) {
            this.getStepManager().logWarning("No class attribute set in the data");
            this.m_classIsSet = false;
        }
        if (this.m_classIsSet && dataSet.classAttribute().isNumeric()) {
            this.getStepManager().logWarning("Class is numeric");
            this.m_classIsNominal = false;
        }
        Instances newDataSet = dataSet;
        if (this.m_classIsSet && this.m_classIsNominal) {
            newDataSet = this.assignClassValue(dataSet);
        }
        Data newData = new Data(data.getConnectionName());
        newData.setPayloadElement(data.getConnectionName(), newDataSet);
        this.getStepManager().outputData(newData);
        this.getStepManager().finished();
    }

    protected Instances assignClassValue(Instances dataSet) throws WekaException {
        Attribute classAtt = dataSet.classAttribute();
        int classValueIndex = classAtt.indexOfValue(this.m_classValue);
        if (classValueIndex == -1) {
            if (this.m_classValue.equalsIgnoreCase("last") || this.m_classValue.equalsIgnoreCase("/last")) {
                classValueIndex = classAtt.numValues() - 1;
            } else if (this.m_classValue.equalsIgnoreCase("first") || this.m_classValue.equalsIgnoreCase("/first")) {
                classValueIndex = 0;
            } else {
                String clV = this.m_classValue;
                if (this.m_classValue.startsWith("/") && this.m_classValue.length() > 1) {
                    clV = clV.substring(1);
                }
                try {
                    classValueIndex = Integer.parseInt(clV);
                    --classValueIndex;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        if (classValueIndex < 0 || classValueIndex > classAtt.numValues() - 1) {
            throw new WekaException("Class label/index '" + this.m_classValue + "' is unknown or out of range!");
        }
        if (classValueIndex != 0) {
            try {
                SwapValues sv = new SwapValues();
                sv.setAttributeIndex("" + (dataSet.classIndex() + 1));
                sv.setFirstValueIndex("first");
                sv.setSecondValueIndex("" + (classValueIndex + 1));
                sv.setInputFormat(dataSet);
                Instances newDataSet = Filter.useFilter(dataSet, sv);
                newDataSet.setRelationName(dataSet.relationName());
                this.getStepManager().logBasic("New class value: " + newDataSet.classAttribute().value(0));
                return newDataSet;
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        }
        return dataSet;
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() > 0) {
            return new ArrayList<String>();
        }
        return Arrays.asList("dataSet", "trainingSet", "testSet");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnectionsOfType("dataSet") > 0) {
            result.add("dataSet");
        } else if (this.getStepManager().numIncomingConnectionsOfType("trainingSet") > 0) {
            result.add("trainingSet");
        } else if (this.getStepManager().numIncomingConnectionsOfType("testSet") > 0) {
            result.add("testSet");
        }
        return result;
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        this.m_classValue = this.getStepManager().environmentSubstitute(this.m_classValueS).trim();
        if (!connectionName.equals("dataSet") && !connectionName.equals("trainingSet") && !connectionName.equals("testSet") && !connectionName.equals("instance") || this.getStepManager().numIncomingConnections() == 0) {
            return null;
        }
        Instances strucForDatasetCon = this.getStepManager().getIncomingStructureForConnectionType("dataSet");
        if (strucForDatasetCon != null) {
            return strucForDatasetCon;
        }
        Instances strucForTestsetCon = this.getStepManager().getIncomingStructureForConnectionType("testSet");
        if (strucForTestsetCon != null) {
            return strucForTestsetCon;
        }
        Instances strucForTrainingCon = this.getStepManager().getIncomingStructureForConnectionType("trainingSet");
        if (strucForTrainingCon != null) {
            return strucForTrainingCon;
        }
        Instances strucForInstanceCon = this.getStepManager().getIncomingStructureForConnectionType("instance");
        if (strucForInstanceCon != null) {
            return strucForInstanceCon;
        }
        return null;
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.ClassValuePickerStepEditorDialog";
    }
}

