/*
 * Decompiled with CFR 0.152.
 */
package cic.server;

import cic.ad.Features;
import cic.ad.Status;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="Server")
public class Server {
    static final String[] MESSAGE = new String[]{"The server has been established correctly.", "Dataset file was not found. The server will function with the existing object files.", "Object files were not found. The server will generate objects with the current dataset file.", "Dataset and object files were not found. Please check all files and restart the server.", "There was an error initializing the server. Please check all files and restart the server or contact the administrtor."};
    static final String SERVER_MISSING = "Server has not been initialized. Please call /init .";
    static Status status = null;
    static final Features f = new Features();
    static boolean serverUp = false;

    @GET
    @Produces(value={"text/plain"})
    public String get() {
        return "This is the main server.\n\t/init : Initializes the server.\n\t/status : Check the status of the server.";
    }

    @GET
    @Path(value="/status")
    @Produces(value={"text/plain"})
    public String getStatus() {
        if (status == null) {
            this.getInit();
        }
        return MESSAGE[Status.getValue(status)];
    }

    @GET
    @Path(value="/init")
    @Produces(value={"text/plain"})
    public String getInit() {
        try {
            f.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        status = f.getStatus();
        return MESSAGE[Status.getValue(status)];
    }

    @GET
    @Path(value="/classify")
    @Produces(value={"text/plain"})
    public String getLabel(@QueryParam(value="url") String url) {
        if (status == null) {
            this.getInit();
        }
        if (status == Status.ALL || status == Status.ERROR) {
            return MESSAGE[Status.getValue(status)];
        }
        return this.getClassification(url) + "";
    }

    public double getClassification(String url) {
        return f.classifyNew(url);
    }

    @PUT
    @Path(value="/feedback")
    public void addLabel() {
    }

    @GET
    @Path(value="/update")
    @Produces(value={"text/plain"})
    public String update() {
        boolean wasNull = false;
        if (status == null) {
            wasNull = true;
            this.getInit();
        }
        if ((status = f.checkFiles()) == Status.SUCCESS || status == Status.OBJ) {
            if (!wasNull) {
                f.update();
            }
            return "Finished updating the server.";
        }
        if (status == Status.DATA) {
            return "Cannot update the server because dataset is missing";
        }
        return MESSAGE[Status.getValue(status)];
    }
}

