/*
 * Decompiled with CFR 0.152.
 */
package cic.server;

import com.sun.jersey.api.container.httpserver.HttpServerFactory;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.ws.rs.core.UriBuilder;

public class Main {
    static int portNumber = 8085;

    public static void main(String[] args) throws IOException {
        System.out.println("Setting up server...");
        HttpServer server = Main.createHttpServer();
        server.start();
        System.out.println("Server started!");
    }

    private static HttpServer createHttpServer() throws IOException {
        PackagesResourceConfig resourceConfig = new PackagesResourceConfig("cic.server");
        return HttpServerFactory.create(Main.getUri(), (ResourceConfig)resourceConfig);
    }

    private static URI getUri() {
        return UriBuilder.fromUri("http://" + Main.getHostName() + "/").port(portNumber).build(new Object[0]);
    }

    private static String getHostName() {
        String hostName = "localhost";
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return hostName;
    }
}

