/*
 * Decompiled with CFR 0.152.
 */
package cic.ad;

import cic.ad.FeatureVector;
import cic.ad.Tokens;
import java.io.Serializable;
import java.net.URI;
import java.util.List;

public class Lexical
implements Serializable {
    private static final long serialVersionUID = 1L;
    int startIndex = 1;
    int numLengthFeatures = 0;
    String[] NS = new String[]{";", "&", ".", "/", ",", "?", "=", "(", ")", "[", "]", "+", "@", "%"};
    int numDigitCountFeatures = 0;
    int numDigitRatioFeatures = 0;
    int numLengthRatioFeatures = 0;
    int numTokenLengthFeatures = 0;
    int numTokenNumberFeatures = 0;
    int numDldLdlFeatures = 0;
    int numCharContFeatures = 0;
    int numAlphabetEntropyFeatures = 0;
    int numUrlFeatures = 0;
    int numFeatures = 43;

    public void makeVector(FeatureVector f) {
        int index = this.startIndex;
        if (f.getUri() == null) {
            return;
        }
        f = this.makeLength(f, index);
        f = this.makeOccurrence(f, this.NS, index += this.numLengthFeatures);
        f = this.makeDigitCount(f, index += this.NS.length);
        f = this.makeDigitRatio(f, index += this.numDigitCountFeatures);
        f = this.makeLengthRatio(f, index += this.numDigitRatioFeatures);
        f = this.makeTokenLength(f, index += this.numLengthRatioFeatures);
        f = this.makeTokenNumber(f, index += this.numTokenLengthFeatures);
        f = this.makeDldLdlSequence(f, index += this.numTokenNumberFeatures);
        f = this.makeCharCont(f, index += this.numDldLdlFeatures);
        f = this.makeAlphabetEntropy(f, index += this.numCharContFeatures);
        f = this.makeUrlSyntax(f, index += this.numAlphabetEntropyFeatures);
        index += this.numUrlFeatures;
    }

    public FeatureVector makeTokenLength(FeatureVector f, int index) {
        URI uri = f.getUri();
        int skip = 0;
        List<String> queryTokens = Tokens.getTokens(uri.getQuery());
        int queryLong = Tokens.getLongestToken(queryTokens).length();
        f.addFeature(index + skip++, queryLong, "longest_token_length_in_query");
        List<String> pathTokens = Tokens.getTokens(uri.getPath());
        int pathLong = Tokens.getLongestToken(pathTokens).length();
        f.addFeature(index + skip++, pathLong, "longest_token_length_in_path");
        double avgPathTokenLength = Tokens.getAverageTokenLength(pathTokens);
        f.addFeature(index + skip++, avgPathTokenLength, "avg_token_length_in_path");
        if (this.numTokenLengthFeatures == 0) {
            this.numTokenLengthFeatures = skip;
        }
        return f;
    }

    public FeatureVector makeTokenNumber(FeatureVector f, int index) {
        int skip = 0;
        List<String> domainTokens = Tokens.getTokens(f.getUri().getHost());
        f.addFeature(index + skip++, domainTokens.size(), "num_token_in_domain");
        if (this.numTokenNumberFeatures == 0) {
            this.numTokenNumberFeatures = skip;
        }
        return f;
    }

    public FeatureVector makeLength(FeatureVector f, int index) {
        URI uri = f.getUri();
        int skip = 0;
        f.addFeature(index + skip++, this.getLength(f.getUrl()), "length_url");
        f.addFeature(index + skip++, this.getLength(uri.getHost()), "length_domain");
        String[] directoryFile = this.divideDirectoryFile(uri.getPath());
        f.addFeature(index + skip++, this.getLength(directoryFile[0]), "length_directory");
        f.addFeature(index + skip++, this.getLength(directoryFile[1]), "length_filename");
        if (this.numLengthFeatures == 0) {
            this.numLengthFeatures = skip;
        }
        return f;
    }

    public FeatureVector makeDldLdlSequence(FeatureVector f, int index) {
        int i;
        int[] urlSequence = this.getDldAndLdl(f.getUrl());
        int[] pathSequence = this.getDldAndLdl(f.getUri().getPath());
        int skip = 0;
        String[] urlName = new String[]{"dld_url", "ldl_url", "dld_path", "ldl_path"};
        for (i = 0; i < urlSequence.length; ++i) {
            f.addFeature(index + skip, urlSequence[i], urlName[skip]);
            ++skip;
        }
        for (i = 0; i < pathSequence.length; ++i) {
            f.addFeature(index + skip, pathSequence[i], urlName[skip]);
            ++skip;
        }
        if (this.numDldLdlFeatures == 0) {
            this.numDldLdlFeatures = skip;
        }
        return f;
    }

    public int[] getDldAndLdl(String url) {
        int[] DLDandLDL = new int[2];
        if (url == null || url.length() == 0) {
            return DLDandLDL;
        }
        int nDigit = 0;
        int nLetter = 0;
        int digit = -1;
        int letter = 0;
        boolean isDigit = false;
        if (!Character.isLetterOrDigit(url.charAt(0))) {
            letter = -1;
        } else if (Character.isDigit(url.charAt(0))) {
            digit = 0;
            letter = -1;
            isDigit = true;
        }
        for (int i = 1; i < url.length(); ++i) {
            if (!Character.isLetterOrDigit(url.charAt(i))) {
                letter = -1;
                digit = -1;
                continue;
            }
            if (letter == -1 && digit == -1) {
                if (Character.isDigit(url.charAt(i))) {
                    digit = 0;
                    isDigit = true;
                    continue;
                }
                letter = 0;
                isDigit = false;
                continue;
            }
            if (isDigit && !Character.isDigit(url.charAt(i))) {
                isDigit = false;
                ++digit;
                ++letter;
            } else if (!isDigit && Character.isDigit(url.charAt(i))) {
                isDigit = true;
                ++digit;
                ++letter;
            }
            if (digit == 2) {
                ++nDigit;
                digit = 0;
            }
            if (letter != 2) continue;
            ++nLetter;
            letter = 0;
        }
        DLDandLDL[0] = nDigit;
        DLDandLDL[1] = nLetter;
        return DLDandLDL;
    }

    public FeatureVector makeOccurrence(FeatureVector f, String[] symbols, int index) {
        String url = f.getUrl();
        for (int i = 0; i < symbols.length; ++i) {
            int count = this.getOccurrence(url, symbols[i]);
            f.addFeature(index + i, count, "num_occurrence_of_" + symbols[i]);
        }
        return f;
    }

    public FeatureVector makeDigitCount(FeatureVector f, int index) {
        String query = f.getUri().getQuery();
        int count = this.getDigitCount(query);
        f.addFeature(index, count, "num_digit_in_query");
        if (this.numDigitCountFeatures == 0) {
            this.numDigitCountFeatures = 1;
        }
        return f;
    }

    public FeatureVector makeDigitRatio(FeatureVector f, int index) {
        int skip = 0;
        URI uri = f.getUri();
        f.addFeature(index + skip++, this.getDigitRatio(uri.getHost()), "digit_ratio_domain");
        String[] directoryFile = this.divideDirectoryFile(uri.getPath());
        f.addFeature(index + skip++, this.getDigitRatio(directoryFile[0]), "digit_ratio_directory");
        f.addFeature(index + skip++, this.getDigitRatio(directoryFile[1]), "digit_ratio_filename");
        f.addFeature(index + skip++, this.getDigitRatio(f.getUrl()), "digit_ratio_url");
        f.addFeature(index + skip++, this.getDigitRatio(uri.getQuery()), "digit_ratio_query");
        if (this.numDigitRatioFeatures == 0) {
            this.numDigitRatioFeatures = skip;
        }
        return f;
    }

    public FeatureVector makeAlphabetEntropy(FeatureVector f, int index) {
        double entropy = this.getEntropy(f.getUrl());
        int skip = 0;
        f.addFeature(index + skip++, entropy, "alphabet_entropy");
        if (this.numAlphabetEntropyFeatures == 0) {
            this.numAlphabetEntropyFeatures = skip;
        }
        return f;
    }

    public String[] divideDirectoryFile(String path) {
        String[] array = new String[2];
        if (path == null || path.length() == 0) {
            return array;
        }
        int lastIndex = path.lastIndexOf("/");
        if (lastIndex == -1) {
            return array;
        }
        array[0] = path.substring(0, lastIndex);
        array[1] = path.substring(lastIndex);
        return array;
    }

    public FeatureVector makeUrlSyntax(FeatureVector f, int index) {
        URI uri = f.getUri();
        int skip = 0;
        String query = uri.getQuery();
        if (query != null) {
            f.addFeature(index + skip++, 1.0, "url_contains_query");
            if (query.toLowerCase().contains("userinfo")) {
                f.addFeature(index + skip++, 1.0, "url_contains_userinfo");
            } else {
                f.addFeature(index + skip++, 0.0, "url_contains_userinfo");
            }
            int numQuery = this.getOccurrence(query, "&");
            f.addFeature(index + skip++, numQuery, "url_num_query_params");
        } else {
            f.addFeature(index + skip++, 0.0, "url_contains_query");
            f.addFeature(index + skip++, 0.0, "url_contains_userinfo");
            f.addFeature(index + skip++, 0.0, "url_num_query_params");
        }
        if (this.numUrlFeatures == 0) {
            this.numUrlFeatures = skip;
        }
        return f;
    }

    public FeatureVector makeLengthRatio(FeatureVector f, int index) {
        URI uri = f.getUri();
        String path = uri.getPath();
        String query = uri.getQuery();
        String domain = uri.getHost();
        String url = f.getUrl();
        double[] ratios = new double[]{this.getLengthRatio(query, path), this.getLengthRatio(query, domain), this.getLengthRatio(query, url), this.getLengthRatio(path, domain), this.getLengthRatio(path, url), this.getLengthRatio(domain, url)};
        String[] ratioNames = new String[]{"length_ratio_query_path", "length_ratio_query_domain", "length_ratio_query_url", "length_ratio_path_domain", "length_ratio_path_url", "length_ratio_domain_url"};
        for (int i = 0; i < ratios.length; ++i) {
            f.addFeature(index + i, ratios[i], ratioNames[i]);
        }
        if (this.numLengthRatioFeatures == 0) {
            this.numLengthRatioFeatures = ratios.length;
        }
        return f;
    }

    public FeatureVector makeCharCont(FeatureVector f, int index) {
        double cc = this.getCharacterContinuity(f.getUrl());
        int skip = 0;
        f.addFeature(index + skip++, cc, "character_continuity");
        if (this.numCharContFeatures == 0) {
            this.numCharContFeatures = skip;
        }
        return f;
    }

    public double getCharacterContinuity(String url) {
        int pCharset;
        double cont = 0.0;
        if (url == null || url.length() == 0) {
            return cont;
        }
        int[] max = new int[3];
        int[] count = new int[3];
        int n = pCharset = this.getCharset(Character.valueOf(url.charAt(0)));
        count[n] = count[n] + 1;
        for (int i = 1; i < url.length(); ++i) {
            Character c = Character.valueOf(url.charAt(i));
            int cCharset = this.getCharset(c);
            if (pCharset == cCharset) {
                int n2 = pCharset;
                count[n2] = count[n2] + 1;
            } else {
                for (int j = 0; j < max.length; ++j) {
                    max[j] = Math.max(max[j], count[j]);
                    count[j] = 0;
                }
                int n3 = cCharset;
                count[n3] = count[n3] + 1;
            }
            pCharset = cCharset;
        }
        max[pCharset] = Math.max(max[pCharset], count[pCharset]);
        for (int m : max) {
            cont += (double)m;
        }
        return cont /= (double)url.length();
    }

    public int getCharset(Character c) {
        if (Character.isLetter(c.charValue())) {
            return 0;
        }
        if (Character.isDigit(c.charValue())) {
            return 1;
        }
        return 2;
    }

    public double getDigitRatio(String url) {
        if (url == null) {
            return 0.0;
        }
        int numDigits = this.getDigitCount(url);
        if (url.length() > 0) {
            return (double)numDigits / (double)url.length();
        }
        return 0.0;
    }

    public int getDigitCount(String url) {
        if (url == null) {
            return 0;
        }
        int numDigits = 0;
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (!Character.isDigit(c)) continue;
            ++numDigits;
        }
        return numDigits;
    }

    public int getOccurrence(String url, String matches) {
        int occurrences = 0;
        occurrences = url.length() - url.replace(matches, "").length();
        return occurrences;
    }

    public int getNumFeatures() {
        if (this.numFeatures == 0) {
            this.numFeatures = this.numLengthFeatures + this.NS.length + this.numDigitRatioFeatures + this.numUrlFeatures;
        }
        return this.numFeatures;
    }

    public double getLengthRatio(String url1, String url2) {
        double length2;
        double ratio = 0.0;
        double length1 = url1 == null ? 0.0 : (double)this.getLength(url1);
        if (length1 * (length2 = url2 == null ? 0.0 : (double)this.getLength(url2)) > 0.0) {
            return length1 / length2;
        }
        return ratio;
    }

    public int getLength(String url) {
        int length = 0;
        if (url == null) {
            return length;
        }
        length = url.length();
        return length;
    }

    public int getNumTld(URI uri) {
        int tld = 0;
        return tld;
    }

    public double getEntropy(String url) {
        int i;
        double entropy = 0.0;
        double[] prob = new double[26];
        for (i = 0; i < url.length(); ++i) {
            char index;
            char c = url.charAt(i);
            if (!Character.isLetter(c) || (index = Character.toLowerCase(c)) < 'a' || index > 'z') continue;
            int n = index - 97;
            prob[n] = prob[n] + 1.0;
        }
        for (i = 0; i < prob.length; ++i) {
            double p = prob[i] / (double)url.length();
            if (p == 0.0) continue;
            entropy += p * Math.log10(p);
        }
        return -1.0 * entropy;
    }

    public static void main(String[] args) {
        Lexical l = new Lexical();
        System.out.println(l.getEntropy("abc"));
    }

    public void printFeatureLengths() {
        System.out.println("Num Digit features: " + this.numLengthFeatures);
        System.out.println("Num char occurrence features: " + this.NS.length);
        System.out.println("Num Digit count features: " + this.numDigitCountFeatures);
        System.out.println("Num Digit ratio features: " + this.numDigitRatioFeatures);
        System.out.println("Num length ratio features: " + this.numLengthRatioFeatures);
        System.out.println("Num token length features: " + this.numTokenLengthFeatures);
        System.out.println("Num token number features: " + this.numTokenNumberFeatures);
        System.out.println("Num dld features: " + this.numDldLdlFeatures);
        System.out.println("Num char cont features: " + this.numCharContFeatures);
        System.out.println("Num url features: " + this.numUrlFeatures);
    }
}

