/*
 * Decompiled with CFR 0.152.
 */
package cic.ad;

import cic.ad.Classify;
import cic.ad.FeatureVector;
import cic.ad.Lexical;
import cic.ad.Status;
import cic.ad.Tokens;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class Features {
    Lexical lexical = new Lexical();
    Tokens tokens = new Tokens(this.lexical.getNumFeatures());
    List<FeatureVector> vectors = new ArrayList<FeatureVector>();
    Classify classify = null;
    int numFeatures = -1;
    Status status;
    static final String dir = "./";
    final String classDir = "./classifier.obj";
    final String lexicalDir = "./lexical.obj";
    final String tokenDir = "./token.obj";
    static final String datasetDir = "./dataset.txt";

    public void getFeatureVector(String[] split) {
        FeatureVector f = new FeatureVector(split[0], split[1]);
        this.lexical.makeVector(f);
        this.tokens.makeVector(f, true);
        this.vectors.add(f);
    }

    public void getTestset(File file) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            String[] split = new String[2];
            if (line.startsWith("ad")) {
                split[0] = "ad";
                split[1] = line.substring(3);
            } else if (line.startsWith("mal")) {
                split[0] = "malad";
                split[1] = line.substring(6);
            } else {
                split[0] = "nonad";
                split[1] = line.substring(6);
            }
            this.getFeatureVector(split);
        }
        reader.close();
        this.numFeatures = this.lexical.getNumFeatures() + this.tokens.getNumFeatures();
        this.classify = new Classify(this.vectors.get(0));
        for (FeatureVector fv : this.vectors) {
            this.classify.add(fv);
        }
        this.classify.run();
    }

    public static void main(String[] args) {
        Features f = new Features();
        try {
            f.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Status checkFiles() {
        this.status = Status.SUCCESS;
        File dataset = new File(datasetDir);
        File obj = new File("./classifier.obj");
        if (!dataset.exists() || dataset.isDirectory()) {
            if (!obj.exists() || obj.isDirectory()) {
                this.status = Status.ALL;
                return this.status;
            }
            this.status = Status.DATA;
            return this.status;
        }
        if (!obj.exists() || obj.isDirectory()) {
            this.status = Status.OBJ;
        }
        return this.status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void init() throws Exception {
        this.checkFiles();
        switch (this.status) {
            case SUCCESS: {
                this.load();
                break;
            }
            case DATA: {
                this.load();
                break;
            }
            case OBJ: {
                this.create();
                break;
            }
        }
    }

    public void create() throws Exception {
        File dataset = new File(datasetDir);
        this.getTestset(dataset);
        this.save();
    }

    public void update() {
        try {
            this.getTestset(new File(datasetDir));
            this.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.save("./classifier.obj", this.classify);
        this.save("./lexical.obj", this.lexical);
        this.save("./token.obj", this.tokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String dir, Object obj) {
        String objDir = dir;
        FileOutputStream fout = null;
        ObjectOutputStream oos = null;
        try {
            fout = new FileOutputStream(objDir);
            oos = new ObjectOutputStream(fout);
            oos.writeObject(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void load() {
        this.lexical = (Lexical)this.load("./lexical.obj");
        this.tokens = (Tokens)this.load("./token.obj");
        this.classify = (Classify)this.load("./classifier.obj");
        this.numFeatures = this.lexical.getNumFeatures() + this.tokens.getNumFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(String dir) {
        FileInputStream fin = null;
        ObjectInputStream ois = null;
        Object c = null;
        try {
            fin = new FileInputStream(dir);
            ois = new ObjectInputStream(fin);
            c = ois.readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return c;
    }

    public void doStuff(File file) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            String[] split = new String[2];
            if (line.startsWith("ad")) {
                split[0] = "ad";
                split[1] = line.substring(3);
            } else if (line.startsWith("mal")) {
                split[0] = "malad";
                split[1] = line.substring(6);
            } else {
                split[0] = "nonad";
                split[1] = line.substring(6);
            }
            System.out.println(this.classifyNew(split[1]) + "\t" + split[1]);
        }
        reader.close();
    }

    public double classifyNew(String url) {
        double label = -1.0;
        FeatureVector f = new FeatureVector(url);
        this.lexical.makeVector(f);
        this.tokens.makeVector(f, false);
        try {
            label = this.classify.classifyNew(f, this.numFeatures);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return label;
    }

    public static String getString() {
        return "Hello World!";
    }
}

