/*
 * Decompiled with CFR 0.152.
 */
package cic.ad;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class FeatureVector {
    String label;
    String url;
    URI uri;
    HashMap<Integer, Double> vector;
    static HashMap<Integer, String> vectorName = new HashMap();
    int numFeatures;

    public FeatureVector() {
        this.vector = new HashMap();
        this.numFeatures = 0;
    }

    public FeatureVector(String label, String url) {
        this.label = label;
        this.url = url.charAt(0) == '\'' ? url.substring(1, url.length() - 1) : url;
        try {
            this.makeUri();
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
            this.uri = null;
        }
        this.vector = new HashMap();
        this.numFeatures = 0;
    }

    public FeatureVector(String url) {
        if (url.length() == 0) {
            this.uri = null;
            this.vector = new HashMap();
            this.numFeatures = 0;
            return;
        }
        this.url = url.charAt(0) == '\'' ? url.substring(1, url.length() - 1) : url;
        try {
            this.makeUri();
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
            this.uri = null;
        }
        this.vector = new HashMap();
        this.numFeatures = 0;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void makeUri() throws URISyntaxException, MalformedURLException {
        try {
            this.uri = new URI(this.url);
        }
        catch (URISyntaxException e) {
            URL encodedUrl = new URL(this.url);
            this.uri = new URI(encodedUrl.getProtocol(), encodedUrl.getUserInfo(), encodedUrl.getHost(), encodedUrl.getPort(), encodedUrl.getPath(), encodedUrl.getQuery(), encodedUrl.getRef());
        }
    }

    public HashMap<Integer, Double> getVector() {
        return this.vector;
    }

    public void setVector(HashMap<Integer, Double> vector) {
        this.vector = vector;
    }

    public void addFeature(int index, double value, String name) {
        vectorName.put(index, name);
        if (value == 0.0) {
            return;
        }
        if (this.vector.get(index) != null) {
            double currentValue = this.vector.get(index);
            this.vector.put(index, currentValue += 1.0);
        } else {
            this.vector.put(index, value);
            ++this.numFeatures;
        }
    }

    public double getFeature(int index) {
        if (this.vector.get(index) != null) {
            return this.vector.get(index);
        }
        return -1.0;
    }

    public String toString() {
        TreeSet<Integer> keys = new TreeSet<Integer>(this.vector.keySet());
        String str = "" + this.label + ": ";
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            str = str + "{" + index + "," + this.vector.get(index) + "}";
        }
        return str;
    }

    public int getVectorSize() {
        return this.vector.size();
    }

    public HashMap<Integer, String> getVectorName() {
        return vectorName;
    }

    public String toStringName() {
        TreeSet<Integer> keys = new TreeSet<Integer>(vectorName.keySet());
        String str = "" + this.label + ": ";
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            str = str + "\t{" + index + "," + vectorName.get(index) + "}\n";
        }
        return str;
    }

    public int getNumFeatures() {
        return this.numFeatures;
    }

    public int getNumAllFeatures() {
        int all = vectorName.size();
        return all;
    }
}

