/*
 * Decompiled with CFR 0.152.
 */
package cic.ad;

import cic.ad.FeatureVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.SMO;
import weka.core.Attribute;
import weka.core.Debug;
import weka.core.Instances;
import weka.core.SparseInstance;

public class Classify
implements Serializable {
    private static final long serialVersionUID = 1L;
    String classifierName = "SVM";
    Classifier classifier = new SMO();
    Instances instances = null;
    double weight = 1.0;

    public Classify(FeatureVector f) {
        this.instances = new Instances("Ad", this.makeAttributes(f), f.getVectorSize() + 1);
        if (this.instances.classIndex() == -1) {
            this.instances.setClassIndex(0);
        }
    }

    public void run() throws Exception {
        this.build(this.classifierName, this.classifier, this.instances);
    }

    public void build(String cName, Classifier c, Instances input) throws Exception {
        Instances data = new Instances(input);
        c.buildClassifier(data);
    }

    public void crossValidation(String cName, Classifier c, Instances input, int folds) throws Exception {
        Debug.Random rand = new Debug.Random(1L);
        Instances data = new Instances(input);
        Evaluation eval = new Evaluation(data);
        long start = System.currentTimeMillis();
        eval.crossValidateModel(c, data, folds, rand, new Object[0]);
        c.buildClassifier(data);
        long end = System.currentTimeMillis();
        double time = (double)(end - start) / 1000.0;
        this.printEval(cName, eval, data, time);
        System.out.println("\n\n");
    }

    public double classifyNew(FeatureVector f, int size) throws Exception {
        double[] att = this.convertToArray(f, size);
        SparseInstance sp = new SparseInstance(this.weight, att);
        sp.setDataset(this.instances);
        double label = this.classifier.classifyInstance(sp);
        return label;
    }

    public void add(FeatureVector f) {
        int size = f.getNumAllFeatures();
        double[] att = this.convertToArray(f, size);
        SparseInstance sp = new SparseInstance(this.weight, att);
        this.instances.add(sp);
    }

    public double[] convertToArray(FeatureVector f, int size) {
        double[] att = new double[size + 1];
        HashMap<Integer, Double> vector = f.getVector();
        String label = f.getLabel();
        if (label != null) {
            if (label.equals("ad")) {
                att[0] = 1.0;
            } else if (label.equals("malad")) {
                att[0] = 2.0;
            }
        }
        for (int index : vector.keySet()) {
            att[index] = vector.get(index);
        }
        return att;
    }

    public ArrayList<Attribute> makeAttributes(FeatureVector f) {
        ArrayList<Attribute> att = new ArrayList<Attribute>();
        HashMap<Integer, String> vectorNames = f.getVectorName();
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("nonad");
        labels.add("ad");
        labels.add("malad");
        Attribute label = new Attribute("@@class@@", labels);
        att.add(label);
        for (int index : vectorNames.keySet()) {
            att.add(new Attribute(vectorNames.get(index)));
        }
        return att;
    }

    public Instances getInstances() {
        return this.instances;
    }

    public static void main(String[] args) {
    }

    public void printEval(String name, Evaluation eval, Instances data, double time) {
        System.out.println("Name,Time,Accuracy");
        System.out.println(name + "," + time + "," + eval.pctCorrect());
        System.out.println();
        System.out.println(",TP,FP,Precision,Recall");
        for (int i = 0; i < data.attribute(data.classIndex()).numValues(); ++i) {
            System.out.println(data.attribute(data.classIndex()).value(i) + "," + eval.truePositiveRate(i) + "," + eval.falsePositiveRate(i) + "," + eval.precision(i) + "," + eval.recall(i));
        }
        System.out.println("Weighted Avg," + eval.weightedTruePositiveRate() + "," + eval.weightedFalsePositiveRate() + "," + eval.weightedPrecision() + "," + eval.weightedRecall());
        System.out.println("Confusion Matrix");
        double[][] matrix = eval.confusionMatrix();
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                System.out.print((int)matrix[i][j] + ",");
            }
            System.out.println();
        }
    }
}

